﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CashierCrisis.Core
{
    public class IndexedPriorityQueueLow<Key> where Key : IComparable<Key>
    {
        private List<Key> _keys;
        private List<int> _heap;
        private List<int> _invHeap;
        private int _size;
        private int _maxSize;
       
        public int Count
        {
            get { return _size; }
        }

        public bool Empty
        {
            get { return _size == 0; }
        }

        public IndexedPriorityQueueLow(List<Key> keys, int maxSize)
        {
            _keys = keys;
            _size = 0;
            _maxSize = maxSize;
            _heap = new List<int>(_maxSize + 1);
            _invHeap = new List<int>(_maxSize + 1);
            
            for (int i = 0; i < _maxSize + 1; i++)
            {
                _heap.Add(0);
                _invHeap.Add(0);
            }
        }

        private void Swap(int a, int b)
        {
            int temp = _heap[a];
            _heap[a] = _heap[b];
            _heap[b] = temp;

            _invHeap[_heap[a]] = a;
            _invHeap[_heap[b]] = b;
        }

        private void ReorderUpwards(int n)
        {
            while ((n > 1) && (_keys[_heap[n / 2]].CompareTo(_keys[_heap[n]]) > 0))
            {
                Swap(n / 2, n);
                n /= 2;
            }
        }

        public void ReorderDownwards(int n, int heapSize)
        {
            while ((2 * n) <= heapSize)
            {
                int child = 2 * n;

                if ((child < heapSize) && (_keys[_heap[child]].CompareTo(_keys[_heap[child+1]]) > 0))
                {
                    ++child;
                }

                if (_keys[_heap[n]].CompareTo(_keys[_heap[child]]) > 0)
                {
                    Swap(child, n);
                    n = child;
                }
                
                else
                {
                    break;
                }
            }
        }

        public void Insert(int index)
        {
            if ((_size + 1) <= _maxSize)
            {
                ++_size;

                _heap[_size] = index;
                _invHeap[index] = _size;

                ReorderUpwards(_size);
            }
        }

        public int Pop()
        {
            Swap(1, _size);
            ReorderDownwards(1, _size - 1);
            return _heap[_size--];
        }

        public void ChangePriority(int index)
        {
            ReorderUpwards(_invHeap[index]);
        }
    }
}
